#include <future>

#include "service/get_macs_service.h"
#include "service/options.h"

#include <macs_pg/mailish/repository.h>
#include <internal/mailish/auth_type.h>

using namespace macs::pg::utils;

std::string toString(const macs::ShardUser& user) {
    std::stringstream str;
    str
        << " # ShardUser: "
        << " uid=" << user.uid
        << " migrateTs=" << user.migrateTs;
    return str.str();
}

int main(int argc, char **argv) {
    std::string dsn, shard_id;

    const auto err = parse(argc, argv).as(Dsn(dsn), ShardId(shard_id));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getShard(shard_id, dsn);

    std::cout << "# Get mailish accounts" << std::endl;

    try {
        auto shardUsers = service->mailishAccounts().getUsers();
        std::cout << "# Count: " << shardUsers.size() << std::endl;
        for (auto user: shardUsers) {
            std::cout << toString(user) << std::endl;
        }
        std::cout << "# Ok" << std::endl;
    } catch (const std::exception& e) {
        std::cerr << "# Exception: " << e.what() << std::endl;
    }

    std::cout << "# Complete" << std::endl;

    return 0;
}
