#include <future>

#include "service/get_macs_service.h"
#include "service/options.h"

#include <macs_pg/mailish/repository.h>
#include <macs_pg/mailish/move_coords_factory.h>

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, srcFid, destFid;
    std::vector<std::string> mids;
    std::vector<uint64_t> imapIds, newImapIds;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), SrcFid(srcFid), DstFid(destFid),
            ImapIds(imapIds), NewImapIds(newImapIds), Mids(mids));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    if (mids.size() != imapIds.size() || mids.size() != newImapIds.size()) {
        std::cerr << "mids, imap_ids and new_imap_ids should have same size "
            << mids.size() << " " << imapIds.size() << " " << newImapIds.size() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    std::cout << "# Move mailish messages" << std::endl;

    try {
        macs::MailishMoveCoordsChunk chunk;
        for (std::size_t i = 0; i < mids.size(); ++i) {
            macs::MailishMoveCoordsFactory factory;
            factory
                .mid(mids[i])
                .curImapId(imapIds[i])
                .newImapId(newImapIds[i]);
            chunk.push_back(factory.release());
        }
        service->mailish().moveMessages(srcFid, destFid, chunk);
        std::cout << "# Ok" << std::endl;
    } catch (const std::exception& e) {
        std::cerr << "# Exception: " << e.what() << std::endl;
    }

    std::cout << "# Complete" << std::endl;

    return 0;
}
