#include <boost/program_options.hpp>
#include <boost/lexical_cast.hpp>
#include <macs_pg/macs_pg.h>

#include <service/get_macs_service.h>
#include <service/options.h>
#include "handlers_helper.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn;
    std::vector<std::string> tids;
    std::vector<std::string> lids;
    bool doUnmark;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn),
                                          Tids(tids), Lids(lids),
                                          DoUnmark(doUnmark));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }
    std::list<std::string> tidsList;
    std::list<macs::Label> labelsList;

    std::copy(tids.begin(), tids.end(), std::back_inserter(tidsList));

    const auto service = getMacsService(uid, dsn);
    for (auto lid:lids) {
        labelsList.push_back(service->labels().getLabelByLid(lid));
    };

    if (doUnmark) {
        std::cout << "# Unmark ";
    } else {
        std::cout << "# Mark ";
    }
    std::cout << tids.size() << " threads for uid=" << uid << std::endl;

    try {
        Promise result;
        auto f = result.get_future();
        if (doUnmark) {
            service->envelopes().unmarkEnvelopesByThreads(tidsList, labelsList, OnUpdate(result));
        } else {
            service->envelopes().markEnvelopesByThreads(tidsList, labelsList, OnUpdate(result));
        }
        f.get();
    } catch ( const std::exception & e ) {
        std::cerr << e.what() << std::endl;
        return -1;
    }

    return 0;
}
