#include <future>
#include <iostream>
#include <macs_pg/macs_pg.h>
#include <service/get_macs_service.h>
#include <service/options.h>
#include "envelope_status.h"

using namespace macs::pg::utils;

int main(int argc, char** argv) {
    std::string uid, dsn, fid, statusStr;
    const std::string statusParamDescr = "exclude status.\nAvailable options are: " + getPossibleStatuses();
    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Fid(fid),
        String(statusStr, "without-status", statusParamDescr).notNecessarily());
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    std::promise<void> prom;
    auto f = prom.get_future();
    auto handler = [&prom] (const macs::error_code& error, const macs::Mids& mids) {
        auto p = std::move(prom);
        if (error) {
            mail_errors::setRuntimeError(p, error);
        } else {
            for (const auto& mid: mids) {
                std::cout << mid << std::endl;
            }
            p.set_value();
        }
    };
    try {
        if (!statusStr.empty()) {
            const auto status = getStatus(statusStr);
            service->envelopes().getMidsByFolderWithoutStatus(fid, status, handler);
        } else {
            service->envelopes().getMidsByFolder(fid, handler);
        }
        f.get();
    } catch( const std::exception & e ) {
        std::cerr << e.what() << std::endl;
        return -1;
    }
    return 0;
}

