
#include <iostream>
#include <macs_pg/macs_pg.h>
#include "service/get_macs_service.h"
#include "service/options.h"
#include "envelope_status.h"

using namespace macs::pg::utils;

int main(int argc, char* argv[]) {
    std::string uid, dsn, fid;
    std::string subject, fromAddress;
    int age;
    std::string statusStr;
    const std::string statusParamDescr = "exclude status.\nAvailable options are: " + getPossibleStatuses();
    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Fid(fid),
        String(subject, "subject", "subject filter").notNecessarily(),
        String(fromAddress, "from_address", "from filter").notNecessarily(),
        Int(age, "age", "age filter").notNecessarily(),
        String(statusStr, "without-status", statusParamDescr).notNecessarily());
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);
    auto conds = service->envelopes().query().mids(fid);

    if (!subject.empty()) {
        conds.subject(subject);
    }
    if (!fromAddress.empty()) {
        conds.from(fromAddress);
    }

    if (age > 0) {
        conds.age(macs::Days(age));
    }

    try {
        if (!statusStr.empty()) {
            conds.excludeStatus(getStatus(statusStr));
        }
        for(const auto& mid : conds.get()){
            std::cout << "mid: " << mid << std::endl;
        }
    } catch ( const std::exception & e ) {
        std::cerr << e.what() << std::endl;
    }
    return 0;
}
