#include <macs_pg/macs_pg.h>
#include <service/get_macs_service.h>
#include <service/options.h>
#include "handlers_helper.h"
#include "envelope_status.h"

using namespace macs::pg::utils;
typedef std::map<std::string, macs::Envelope::Status> StrToStatus;


int main(int argc, char **argv) {
    std::string uid, dsn, statusStr;
    std::vector<std::string> mids;
    const std::string statusParamDescr = "exclude status(required).\n"
        "Available options are: " + getPossibleStatuses();

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), String(statusStr, "status", statusParamDescr), Mids(mids));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    macs::Envelope::Status status = getStatus(statusStr);
    const auto service = getMacsService(uid, dsn);

    std::promise<void> prom;
    auto f = prom.get_future();
    auto handler = [&prom] (const macs::error_code& error, const macs::Mids& mids) {
        auto p = std::move(prom);
        if (error) {
            mail_errors::setRuntimeError(p, error);
        } else {
            for (const auto& mid: mids) {
                std::cout << mid << std::endl;
            }
            p.set_value();
        }
    };
    try {
        service->envelopes().query()
                .withoutStatus(macs::Mids(mids.begin(), mids.end()))
                .status(status)
                .get(handler);
        f.get();

    } catch( const std::exception & e ) {
        std::cerr << e.what() << std::endl;
        return -1;
    }
    return 0;
}

