#include <boost/program_options.hpp>
#include <boost/lexical_cast.hpp>
#include <macs_pg/macs_pg.h>

#include <service/get_macs_service.h>
#include <service/options.h>
#include "handlers_helper.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, srcFid, dstFid;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn),
                                          SrcFid(srcFid), DstFid(dstFid));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }
    const auto service = getMacsService(uid, dsn);

    std::cout << "Move messages from folder with fid=" << srcFid
            << " to folder with fid " << dstFid
            << " for uid=" << uid << std::endl;

    try {
        const auto folders = service->folders().getAllFolders();
        const auto & srcFolder = folders.at(srcFid);
        const auto & dstFolder = folders.at(dstFid);
        hooks::Promise result;
        auto f = result.get_future();
        service->folders().moveAssociatedData(srcFolder, dstFolder, hooks::OnUpdate(result));
        f.get();
    } catch( const std::exception & e ) {
        std::cerr << e.what() << std::endl;
        return -1;
    }

    return 0;
}
