#include <macs_pg/macs_pg.h>
#include <service/get_macs_service.h>
#include <service/options.h>
#include "handlers_helper.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, dstFid;
    std::vector<std::string> mids;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn),
                                          Mids(mids), DstFid(dstFid));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }
    std::list<std::string> midsList(mids.begin(), mids.end());
    const auto service = getMacsService(uid, dsn);

    std::cout << "# Move " << mids.size() << " messages "
            << " to folder with fid " << dstFid
            << " for uid=" << uid << std::endl;

    try {
        hooks::Promise result;
        auto f = result.get_future();
        service->envelopes().moveMessages(dstFid, midsList, hooks::OnUpdate(result));
        f.get();
    } catch ( const std::exception & e ) {
        std::cerr << e.what() << std::endl;
        return -1;
    }

    return 0;
}
