#include <boost/algorithm/string/join.hpp>
#include <macs_pg/macs_pg.h>

#include "envelopes_query_helper.h"
#include "service/get_macs_service.h"
#include "service/options.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, fid;
    int from, count;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Fid(fid),
                                          From(from).def(defaultFrom),
                                          Count(count).def(defaultCount));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    std::cout << "****** Execute pins requests for UID=" << uid << std::endl;

    macs::ServicePtr service = getMacsService(uid, dsn);
    const macs::Folder & folder(macs::FolderFactory().fid(fid));
    const macs::Label pinnedLabel = service->labels().getLabelBySymbol(macs::Label::Symbol::pinned_label);

    auto mailboxQuery = service->envelopes().query().inMailbox().from(from).count(count).withLabel(pinnedLabel);
    auto folderQuery = service->envelopes().query().inFolder(folder).from(from).count(count).withoutLabel(pinnedLabel);

    executeQuery("messages with pins for fid=" + fid, mailboxQuery);
    executeQuery("messages without pins for fid=" + fid, folderQuery);
    executeQuery("threads with pins for fid=" + fid, mailboxQuery.groupByThreads());
    executeQuery("threads without pins for fid=" + fid, folderQuery.groupByThreads());

    return 0;
}


