#include <iostream>

#include "service/params.h"
#include "service/options.h"
#include "service/get_macs_service.h"
#include "subscription_io.h"

using namespace macs::pg::utils;


int main(int argc, char **argv) {
    std::string dsn;
    std::string uid;
    std::string workerId;
    std::int64_t subscriptionId;

    const auto err = parse(argc, argv).as(Dsn(dsn), Uid(uid), WorkerId(workerId),
                                          SubscriptionId(subscriptionId));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getShard("42", dsn);
    macs::error_code ec;

    std::cout << "# Set worker_id NULL at subscription " << subscriptionId
              << " with worker_id " << workerId
              << " for user " << uid << std::endl;
    OnSubscription handler;
    auto data = service->subscriptions().release(uid, subscriptionId, workerId);
    handler(ec, data);

    return 0;
}
