#include <iostream>

#include "service/params.h"
#include "service/options.h"
#include "service/get_macs_service.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string dsn;
    std::string uid;
    std::int64_t subscriptionId;
    std::int64_t changeId;

    const auto err = parse(argc, argv).as(Dsn(dsn), Uid(uid),
                                          SubscriptionId(subscriptionId),
                                          ChangeId(changeId));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }
    const auto service = getShard("42", dsn);

    std::cout << "# RemoveFromChangeQueue " << std::endl;

    auto handler = [](const macs::error_code& ec) {
        if (ec) {
            std::cerr << "Error:" << ec.what() << std::endl;
        }
        else {
            std::cout << "Success: true" << std::endl;
        }
    };

    macs::error_code ec;
    const std::vector<macs::ChangeReference> changes({macs::ChangeReference(changeId, uid, subscriptionId)});
    service->changeQueue().remove(changes, macs::io::use_sync[ec]);
    handler(ec);

    return 0;
}