#include <future>

#include "handlers_helper.h"
#include "service/get_macs_service.h"
#include "service/options.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, fid;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Fid(fid));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }
    const auto service = getMacsService(uid, dsn);
    auto folder = service->folders().getFolderByFid(fid);

    std::cout << "Reset unvisited flag of folder with fid=" << fid
              << " for uid=" << uid << std::endl;

    try {
        hooks::Promise result;
        auto f = result.get_future();
        service->folders().resetUnvisited(folder, hooks::OnUpdate(result));
        f.get();
    } catch ( const std::exception & e ) {
        std::cerr << e.what() << std::endl;
        return -1;
    }

    return 0;
}
