#include <future>

#include "service/get_macs_service.h"
#include "service/options.h"

#include <macs_pg/mailish/repository.h>
#include <macs_pg/mailish/auth_data_factory.h>
#include <macs_pg/mailish/account_factory.h>

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn;
    std::string tokenId;
    std::string oauthApp;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), TokenId(tokenId), OauthApp(oauthApp));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    std::cout << "# Save mailish auth data" << std::endl;

    try {
        macs::MailishAuthDataFactory authDataFactory;
        authDataFactory
            .tokenId(tokenId)
            .authType(macs::MailishAuthData::AuthType::Password)
            .uuid("228")
            .oauthApplication(oauthApp)
            .imapCredentials("abacaba")
            .smtpCredentials("abacaba");
        macs::MailishAccountFactory accountFactory;
        accountFactory
            .email("yapoptest@yandex.ru")
            .imapLogin("yapoptest@yandex.ru")
            .imapSsl(true)
            .imapServer("imap.yandex.ru")
            .imapPort(993)
            .smtpLogin("yapoptest@yandex.ru")
            .smtpSsl(true)
            .smtpServer("smtp.yandex.ru")
            .smtpPort(443);
        service->mailish().saveAccount(authDataFactory.release(), accountFactory.release());
        std::cout << "# Ok" << std::endl;
    } catch (const std::exception& e) {
        std::cerr << "# Exception: " << e.what() << std::endl;
    }

    std::cout << "# Complete" << std::endl;

    return 0;
}
