#pragma once

#include <macs_pg/macs_pg.h>

#include "log.h"

namespace macs {
namespace pg {
namespace utils {


inline macs::pg::ServiceFactoryPtr setupMacsServiceFactory(
        UidResolverFactoryPtr uidResolverFactory,
        ShardResolverFactoryPtr shardResolverFactory) {
    const auto bigTimeout = std::chrono::seconds(3);
    macs::pg::ConnectionPoolPtr pool(macs::pg::ConnectionPoolFactory()
        .connectTimeout(bigTimeout).queryTimeout(bigTimeout).workersCount(1).product());
    macs::pg::ServiceFactoryPtr factory(macs::pg::createSeviceFactory(pool, uidResolverFactory, shardResolverFactory));
    factory->queryConf( macs::pg::readQueryConfFile("query.conf") )
        .logger(Log::create());
    factory->transactionTimeout(bigTimeout);
    return factory;

}

inline macs::ServicePtr getMacsService(const std::string& uid, const std::string& connectionStr) {
    auto factory = setupMacsServiceFactory(
        createFakeUidResolverFactory(connectionStr, "shard"),
        nullptr
    );
    return factory->mailbox(uid);
}

inline macs::ShardPtr getShard(const std::string& shard_id, const std::string& connectionStr) {
    auto factory = setupMacsServiceFactory(
        nullptr,
        createFakeShardResolverFactory(connectionStr, "shard")
    );
    return factory->shard(shard_id);

}

} // namespace macs
} // namespace pg
} // utils
