#ifndef MACS_PG_UTILS_SERVICE_HANDLERS
#define MACS_PG_UTILS_SERVICE_HANDLERS

#include <iostream>
#include <string>
#include <macs_pg/macs_pg.h>

namespace macs {
namespace pg {
namespace utils {

namespace {

inline void showQueryName(const std::string& name) {
    std::cout << "\n===============================================" << std::endl;
    std::cout << "Begin request " << name << std::endl;
    std::cout << "===============================================" << std::endl
              << std::endl;
}

template<class Data>
inline void print(const Data& data) {
    for (auto i : data) {
        std::cout << i << " ";
    }
    std::cout << std::endl << std::endl;
}

}

template<class Data>
struct Async {
    using Promise = std::promise<void>;

    std::string queryName_;
    std::shared_ptr<Promise> promise;

    Async(const std::string& name)
        : queryName_(name),
          promise(std::make_shared<Promise>())
    {}

    void await() {
        promise->get_future().get();
    }

    void operator()(const macs::error_code& code, const Data &data) {
        showQueryName(queryName_);
        std::cout << "Async version" << std::endl
                  << "-----------------------------------------------" << std::endl
                  << "Size: " << data.size() << std::endl
                  << "Code: " << code << std::endl
                  << "Message: " << code.message() << std::endl
                  << "Data: ";
        print(data);
        promise->set_value();
    }
};

template<class Data>
struct Sync {
    std::string queryName_;

    Sync(const std::string& name) : queryName_(name) { }

    void operator()(int result, const Data& data) const {
        showQueryName(queryName_);
        std::cout << "Sync version" << std::endl
                  << "-----------------------------------------------" << std::endl
                  << "Result: " << result << std::endl
                  << "Size: " << data.size() << std::endl
                  << "Data: ";
        print(data);
    }

    void operator()(const Data& data) const {
        showQueryName(queryName_);
        std::cout << "Sync version" << std::endl
                  << "-----------------------------------------------" << std::endl
                  << "Size: " << data.size() << std::endl
                  << "Data: ";
        print(data);
    }
};


}
}
}

#endif // MACS_PG_UTILS_SERVICE_HANDLERS

