#ifndef MACS_PG_UTILS_SERVICE_LOG_H
#define MACS_PG_UTILS_SERVICE_LOG_H

#include <iostream>
#include <boost/make_shared.hpp>
#include <macs_pg/logging.h>

namespace macs {
namespace pg {
namespace utils {

class Log : public logging::v2::Log {
public:
    void log(const logging::Level level, const logging::Method& method,
             const logging::Message& message, logging::Attributes) override {
        std::cout << "macs_pg status=" << toString(level) << "reason=[" << method << ':'
                  << message << "]" << std::endl;
    }

    bool applicable(const logging::Level) override {
        return true;
    }

    static logging::v2::LogPtr create() {
        return std::make_shared<Log>();
    }

private:
    static const char* toString(const logging::Level level) {
        switch (level) {
            case logging::Level::Error:
                return "error";
            case logging::Level::Warning:
                return "warning";
            case logging::Level::Notice:
                return "notice";
            case logging::Level::Debug:
                return "debug";
            default:
                throw std::runtime_error("unknown log level");
        }
    }
};

} // namespace utils
} // namespace pg
} // namespace macs

#endif
