#include <future>

#include "handlers_helper.h"
#include "service/get_macs_service.h"
#include "service/options.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn;
    std::vector<std::string> fids;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Fids(fids).notNecessarily());
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }
    const auto service = getMacsService(uid, dsn);

    std::cout << "# Set pop3 for fids=" << boost::algorithm::join(fids, ", ")
              << " for uid=" << uid << std::endl;

    hooks::Promise result;
    auto future = result.get_future();
    service->folders().setPop3(fids, hooks::OnUpdate(result));
    future.get();

    return 0;
}
