#include <future>

#include "service/get_macs_service.h"
#include "service/options.h"

#include <macs_pg/mailish/repository.h>
#include <macs_pg/mailish/auth_data_factory.h>
#include <macs_pg/mailish/account_factory.h>

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    std::cout << "# Set security lock " << std::endl;

    try {
        service->mailish().eraseSecurityLocks();
        std::cout << "# Ok" << std::endl;
    } catch (const std::exception& e) {
        std::cerr << "# Exception: " << e.what() << std::endl;
    }

    std::cout << "# Complete" << std::endl;

    return 0;
}
