#ifndef MACS_PG_SORT_ENVELOPES_HELPER_H_141420052015
#define MACS_PG_SORT_ENVELOPES_HELPER_H_141420052015

#include <boost/unordered_map.hpp>
#include <boost/assign/list_of.hpp>

namespace macs {
namespace pg {
namespace utils {

using OrderMap = boost::unordered_map<std::string, macs::EnvelopesSorting>;
inline const OrderMap& getOrderMap() {
    using namespace macs;
    static const OrderMap orderMap = boost::assign::map_list_of
            ("received_descending", EnvelopesSorting(SortingType_descending))
            ("received_ascending", EnvelopesSorting(SortingType_ascending))
    ;
    return orderMap;
}

inline macs::EnvelopesSorting defineEnvelopesSorting(const std::string & sort) {
    OrderMap::const_iterator found = getOrderMap().find(sort);
    return found != getOrderMap().end() ? found->second : macs::EnvelopesSorting();
}

} // namespace utils
} // namespace pg
} // namespace macs

#endif /* MACS_PG_SORT_ENVELOPES_HELPER_H_141420052015 */
