
#include <future>
#include <iostream>
#include <macs_pg/macs_pg.h>
#include <service/get_macs_service.h>
#include <service/options.h>

using namespace macs::pg::utils;

int main(int argc, char* argv[]) {
    std::string uid, dsn;
    std::vector<std::string> mids;
    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn),
                                          Mids(mids));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }
    const auto service = getMacsService(uid, dsn);

    try {
        std::list<std::string> midsList;
        std::copy(mids.begin(), mids.end(), std::back_inserter(midsList));
        std::promise<void> prom;
        auto f = prom.get_future();
        auto handler = [&prom] (const macs::error_code& error, const macs::MidsWithStids& midsWithStids) {
            auto p = std::move(prom);
            if (error) {
                mail_errors::setRuntimeError(p, error);
            } else {
                for (const auto& midStid: midsWithStids) {
                    std::cout << midStid.mid << " => " << midStid.stid << std::endl;
                }
                p.set_value();
            }
        };
        service->envelopes().getMessageStIds(midsList, handler);
        f.get();
    } catch ( const std::exception & e ) {
        std::cerr << e.what() << std::endl;
        return -1;
    }

    return 0;
}
