#include "service/get_macs_service.h"
#include "service/options.h"
#include "handlers_helper.h"
#include "envelope_io.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, ownerUid, ownerFid;
    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn),
        OwnerUid(ownerUid), OwnerFid(ownerFid));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    std::cout << "# Fetching envelopes for uid=" << uid << " belonging to owner_uid=" << ownerUid
        << " and owner_fid=" << ownerFid << std::endl;

    try {
        auto envelopes = service->subscribedFolders().getEnvelopes(ownerUid, ownerFid);
        for (const auto& e: envelopes) {
            EnvelopePrinter(std::cout, envelopePrintAllMailInfo).print(e);
        }

        std::cout << "Total fetched: " << envelopes.size() << std::endl;
    } catch (const std::exception& e) {
        std::cout << "exception: " << e.what() << std::endl;
    }
    return 0;
}
