#ifndef MACS_PG_UTILS_SUBSCRIPTION_IO_H_
#define MACS_PG_UTILS_SUBSCRIPTION_IO_H_

#include <iostream>
#include <macs_pg/subscription/subscription.h>

namespace macs {
namespace pg {
namespace utils {


std::ostream & operator << ( std::ostream& s,  const macs::Subscription& sub ) {
    s << "- SubscriptionId: " << sub.subscriptionId()
      << "\n  Uid: "<< sub.uid()
      << "\n  Fid: "<< sub.fid()
      << "\n  SubscriberUid: "<< sub.subscriberUid()
      << "\n  WorkerId: " << (sub.workerId() ? *(sub.workerId()) : "null")
      << "\n  State: " << sub.state()
      << std::endl;
    return s;
}

std::ostream & operator << ( std::ostream& s,  const macs::SubscriptionsChunk& subsChunk ) {
    for (auto sub:subsChunk) {
        s << sub;
    }
    return s;
}

template <typename T>
struct OnSubscriptionHandler {
    void operator()(const macs::error_code& err, const T& sub) const {
        if( err ) {
            std::cerr << "code: " << err.value() << " message: " <<  err.message() << std::endl;
        } else {
            std::cout << sub;
        }
    }
};

typedef OnSubscriptionHandler<macs::Subscription> OnSubscription;
typedef OnSubscriptionHandler<macs::SubscriptionsChunk> OnSubscriptionsChunk;


} // namespace utils
} // namespace pg
} // namespace macs


#endif /* MACS_PG_UTILS_SUBSCRIPTION_IO_H_ */