#include "service/get_macs_service.h"
#include "service/options.h"
#include "handlers_helper.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, ownerUid, ownerFid;
    std::vector<std::string> ownerMids;
    uint64_t ownerRevision = 0;
    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), OwnerUid(ownerUid),
        OwnerFid(ownerFid), OwnerMids(ownerMids), OwnerRevision(ownerRevision));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    using boost::algorithm::join;
    std::cout << "# Sync delete messages for uid=" << uid << " belonging to owner_uid=" << ownerUid
        << " and owner_fid=" << ownerFid << " with owner_mids=" << join(ownerMids, ", ")
        << " and owner_revision=" << ownerRevision << std::endl;

    try {
        auto res = service->subscribedFolders().deleteMessages(ownerUid, ownerFid, ownerMids, ownerRevision);
        printResult(res);
    } catch (const std::exception& e) {
        std::cout << "exception: " << e.what() << std::endl;
    }
    return 0;
}
