#include "service/get_macs_service.h"
#include "service/options.h"
#include "handlers_helper.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, ownerUid, ownerFid, ownerTid;
    std::vector<std::string> ownerJoinTids;
    uint64_t ownerRevision = 0;
    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), OwnerUid(ownerUid),
        OwnerFid(ownerFid), OwnerTid(ownerTid), OwnerJoinTids(ownerJoinTids),
        OwnerRevision(ownerRevision));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    using boost::algorithm::join;
    std::cout << "# Sync join threads for uid=" << uid << " belonging to owner_uid=" << ownerUid
        << " and owner_fid=" << ownerFid << " from owner_join_tids=" << join(ownerJoinTids, ", ")
        << " into owner_tid=" << ownerTid << " and owner_revision=" << ownerRevision << std::endl;

    try {
        auto res = service->subscribedFolders().joinThreads(
                    ownerUid, ownerFid, ownerTid, ownerJoinTids, ownerRevision);
        printResult(res);
    } catch (const std::exception& e) {
        std::cout << "exception: " << e.what() << std::endl;
    }
    return 0;
}
