#include "service/get_macs_service.h"
#include "service/options.h"
#include "handlers_helper.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, ownerUid, ownerFid;
    std::vector<std::string> ownerMids, lids;
    std::uint64_t ownerRevision = 0;
    bool doUnlabel = false;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), OwnerUid(ownerUid),
        OwnerFid(ownerFid), OwnerMids(ownerMids), OwnerRevision(ownerRevision),
        Lids(lids), DoUnlabel(doUnlabel));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const char* operation = doUnlabel ? "label" : "unlabel";

    using boost::algorithm::join;
    std::cout << "# Sync " << operation << " messages for uid=" << uid
              << " belonging to owner_uid=" << ownerUid
              << " and owner_fid=" << ownerFid << " with owner_mids=" << join(ownerMids, ", ")
              << " and owner_revision=" << ownerRevision
              << " with lids=" << join(lids, ", ") << std::endl;

    const auto service = getMacsService(uid, dsn);

    std::vector<macs::Label> labels;
    const macs::LabelSet labelSet = service->labels().getAllLabels();

    for (const auto& lid : lids) {
        const auto iter = labelSet.find(lid);
        if (iter == labelSet.end()) {
            std::cerr << "Label for lid=" << lid << " not found" << std::endl;
        } else {
            labels.push_back(iter->second);
        }
    }

    if (labels.size() != lids.size()) {
        return -1;
    }

    const auto label = [&]() {
        return service->subscribedFolders().labelMessages(ownerUid, ownerFid, ownerMids,
                                                          ownerRevision, labels);
    };

    const auto unlabel = [&]() {
        return service->subscribedFolders().unlabelMessages(ownerUid, ownerFid, ownerMids,
                                                            ownerRevision, labels);
    };

    try {
        const auto res = doUnlabel ? label() : unlabel();
        printResult(res);
    } catch (const std::exception& e) {
        std::cout << "exception: " << e.what() << std::endl;
    }
    return 0;
}
