#include <iostream>
#include <boost/algorithm/string/join.hpp>

#include <macs_pg/macs_pg.h>
#include <macs/threads_repository.h>

#include "service/options.h"
#include "service/handlers.h"
#include "service/get_macs_service.h"

using namespace std;
using namespace macs::pg;
using namespace macs::pg::utils;

int main(int argc, char** argv)
{
    string uid, fid, dsn;
    vector<string> tids;

    const auto err = parse(argc, argv).as(Uid(uid), Fid(fid), Dsn(dsn), Tids(tids));
    if (err) {
        std::cerr << err.message() << endl;
        return -1;
    }

    list<string> result;

    utils::Sync<list<string>> sync("fillIdsFList");
    utils::Async<list<string>> async("fillIdsFList");
    macs::ServicePtr service = utils::getMacsService(uid, dsn);

    list<string> t(tids.begin(), tids.end());
    sync(service->threads().fillIdsFList(t, fid));
    service->threads().fillIdsFList(t, fid, async);

    async.await();
    return 0;
}

