#include <iostream>
#include <boost/algorithm/string/join.hpp>

#include <macs_pg/macs_pg.h>
#include <macs/threads_repository.h>

#include "service/options.h"
#include "service/handlers.h"
#include "service/get_macs_service.h"
#include "envelope_status.h"

using namespace std;
using namespace macs::pg;
using namespace macs::pg::utils;

int main(int argc, char** argv)
{
    string uid, dsn, statusStr;
    vector<string> mids, tids;
    const std::string statusParamDescr = "exclude status.\nAvailable options are: " + getPossibleStatuses();

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Mids(mids), Tids(tids),
        String(statusStr, "without-status", statusParamDescr).notNecessarily());
    if (err) {
        std::cerr << err.message() << endl;
        return -1;
    }

    list<string> result;
    macs::ServicePtr service = getMacsService(uid, dsn);
    list<string> m(mids.begin(), mids.end());
    list<string> t(tids.begin(), tids.end());

    if (!statusStr.empty()) {
        const auto status = getStatus(statusStr);
        Sync<list<string>> sync("fillIdsListWithoutStatus");
        sync(service->threads().fillIdsListWithoutStatus(m, t, status));
    } else {
        Sync<list<string>> sync("fillIdsList");
        Async<list<string>> async("fillIdsList");
        sync(service->threads().fillIdsList(m, t));
        service->threads().fillIdsList(m, t, async);
        async.await();
    }

    return 0;
}
