#include <iostream>
#include <boost/algorithm/string/join.hpp>

#include <macs_pg/macs_pg.h>
#include <macs/threads_repository.h>

#include "service/options.h"
#include "service/handlers.h"
#include "service/get_macs_service.h"

using ThreadMailboxItems = macs::ThreadMailboxItems;
using ThreadMailboxItem = macs::ThreadMailboxItem;

using namespace std;
using namespace macs::pg;
using namespace macs::pg::utils;

ostream& operator<<(ostream& out, const ThreadMailboxItem& item);

int main(int argc, char** argv)
{
    string uid, dsn;
    vector<string> mids, tids;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Mids(mids), Tids(tids));
    if (err) {
        std::cerr << err.message() << endl;
        return -1;
    }

    Sync<ThreadMailboxItems> sync("fillIdsMap");
    Async<ThreadMailboxItems> async("fillIdsMap");
    macs::ServicePtr service = getMacsService(uid, dsn);

    list<string> m(mids.begin(), mids.end());
    list<string> t(tids.begin(), tids.end());
    sync(service->threads().fillIdsMap(m, t));
    service->threads().fillIdsMap(m, t, async);

    async.await();
    return 0;
}

ostream& operator<<(ostream& out, const ThreadMailboxItem& item) {

    out << "{\n ";
#define PARAM(name) "\t" << #name": \'" << item.name << '\''
    out << PARAM(mid) << ", \n"
        << PARAM(fid) << ", \n"
        << PARAM(threadId) << ", \n"
        << PARAM(receivedDate) << ", \n"
        << PARAM(stid) << ", \n";
#undef PARAM

    out << "\tlabels: { ";
    for(const string& i : item.labels) {
        out << '\'' << i << "\' ";
    }
    out << "} \n";
    out << "}\n ";

    return out;
}

