#include <iostream>
#include <boost/algorithm/string/join.hpp>

#include <macs_pg/macs_pg.h>
#include <macs/threads_repository.h>

#include "service/options.h"
#include "service/handlers.h"
#include "service/get_macs_service.h"

using namespace std;
using namespace macs::pg;
using namespace macs::pg::utils;

using ThreadLabelsList = macs::ThreadLabelsList;
using ThreadLabels = macs::ThreadLabels;
using TLabel = ThreadLabels::TLabel;

ostream& operator<<(ostream& out, const ThreadLabels& lab);

int main(int argc, char** argv)
{
    string uid, dsn;
    vector<string> tids;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Tids(tids));
    if (err) {
        std::cerr << err.message() << endl;
        return -1;
    }

    Sync<ThreadLabelsList> sync("getThreadLabels");
    Async<ThreadLabelsList> async("getThreadLabels");
    macs::ServicePtr service = getMacsService(uid, dsn);

    sync(service->threads().getThreadLabels(tids));
    service->threads().getThreadLabels(tids, async);
    async.await();

    return 0;
}


ostream& operator<<(ostream& out, const ThreadLabels& lab) {
    out << "{ \n"
        << "\t" << "tid: \'" << lab.tid()  << "\', \n"
        << "\t" << "revision: \'" << lab.tscn() << "\', \n";

    out << "\t" << "labels { ";
    for(const TLabel& i : lab.labels()) {
        out << "(lid: \'" << i.lid() << "\', count: \'" << i.cnt() << "\') ";
    }
    out << "}\n";
    out << "}";

    return out;
}
