#include <iostream>
#include <boost/algorithm/string/join.hpp>
#include <boost/fusion/adapted.hpp>
#include <boost/fusion/include/for_each.hpp>

#include <macs_pg/macs_pg.h>
#include <macs/threads_repository.h>

#include "service/options.h"
#include "service/handlers.h"
#include "service/get_macs_service.h"

using namespace std;
using namespace macs::pg;
using namespace macs::pg::utils;

using ThreadParticipants = macs::ThreadParticipants;
using Participant = macs::ThreadParticipants::Participant;
using ThreadParticipantsList = macs::ThreadParticipantsList;

ostream& operator<<(ostream& out, const ThreadParticipants& par);

int main(int argc, char** argv)
{
    string uid, dsn;
    vector<string> tids;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Tids(tids));
    if (err) {
        std::cerr << err.message() << endl;
        return -1;
    }

    Sync<ThreadParticipantsList> sync("getThreadsParticipants");
    Async<ThreadParticipantsList> async("getThreadsParticipants");
    macs::ServicePtr service = getMacsService(uid, dsn);

    service->threads().getThreadsParticipants(tids, async);
    sync(service->threads().getThreadsParticipants(tids));
    async.await();

    return 0;
}

ostream& operator<<(ostream& out, const ThreadParticipants& par) {

    out << "tid: \'" << par.threadId() << "\'\n";
    for(const Participant& i : par.participants()) {
        out << "\t { mid: \'" << i.mid() << "\', from: \'" << i.from().addressString() << "\', ";

        out << " types: ( ";
        for (auto t : i.types()) {
            out << "\'" << t << "\' ";
        }
        out << ") } \n";
    }

    return out;
}
