#include <iostream>
#include <future>
#include <macs_pg/macs_pg.h>
#include <service/get_macs_service.h>
#include <service/options.h>

using namespace macs::pg::utils;

int main(int argc, char** argv) {
    std::string uid, dsn, lid;
    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Lid(lid));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    auto handler = [] (const macs::error_code& error, size_t count) {
        if (error) {
            std::cout << "error: " << error.message() << std::endl;
        } else {
            std::cout << "count = " << count << std::endl;
        }
    };

    macs::error_code ec;
    const auto count = service->labels().getThreadsCount(lid, macs::io::use_sync[ec]);
    handler(ec, count);
    return 0;
}
