#include "envelopes_query_helper.h"
#include "service/options.h"

using namespace macs::pg::utils;
using boost::algorithm::join;

int main(int argc, char **argv) {
    std::string uid, dsn;
    std::vector<std::string> tids;
    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Tids(tids));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    std::cout << "Select threads with tids=" << join(tids, ", ") << " for uid=" << uid << std::endl;

    const auto service = getMacsService(uid, dsn);
    macs::EnvelopesQueryThreads query = service->envelopes().query().threads(tids);
    executeQuery("ThreadsByTids", query);

    return 0;
}
