#include <future>

#include "service/get_macs_service.h"
#include "service/options.h"

#include <macs_pg/mailish/repository.h>
#include <macs_pg/mailish/folder.h>

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn;
    std::string fid;
    uint64_t from, to;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Fid(fid), ImapIdFrom(from), ImapIdTo(to));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    std::cout << "# Update downloaded range" << std::endl;

    try {
        service->mailish().updateDownloadedRange(fid, static_cast<uint32_t>(from), static_cast<uint32_t>(to));
        std::cout << "# Ok" << std::endl;
    } catch (const std::exception& e) {
        std::cerr << "# Exception: " << e.what() << std::endl;
    }

    std::cout << "# Complete" << std::endl;

    return 0;
}
