#include <future>

#include <service/get_macs_service.h>
#include <service/options.h>

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    const std::string descr = "set given parent_id - optional, unset (imap strategy) by default";
    std::string uid, dsn, fid, name, parent;
    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Fid(fid),
                                          String(name, "name", "set given name - required"),
                                          ParentFid(parent, "parent_fid", descr).notNecessarily());

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    std::cout << "Update folder fid=" << fid << " with name=\"" << name << "\""
              << " and parent_fid=" << parent << " for user with uid=" << uid << std::endl;

    macs::FolderFactory factory;
    factory.fid(fid).name(name).parentId(parent);

    std::promise<void> result;
    auto f = result.get_future();

    const auto handle = [&] (const macs::error_code& ec,
            const macs::Folder& f) {
        auto p = std::move(result);
        if (ec) {
            mail_errors::setRuntimeError(p, ec);
        } else {
            std::cout << "New name is " << f.name()
                      << " parent folder fid is " << f.parentId()
                      << " with rev " << f.revision() << std::endl;
            p.set_value();
        }
    };

    try {
        service->folders().updateFolder(factory.product(), handle);
        f.get();
    } catch (const std::exception& e) {
        std::cerr << e.what() << std::endl;
    }

    return 0;
}
