#include <future>

#include <service/get_macs_service.h>
#include <service/options.h>

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, lid, name, color;
    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Lid(lid),
                                          String(name, "name", "set given name - required"),
                                          String(color, "color", "set given color - required"));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    std::cout << "Update label lid=" << lid << " with name=\"" << name << "\""
              << " and color=\"" << color << "\" for user with uid=" << uid << std::endl;

    macs::LabelFactory factory;
    factory.lid(lid).name(name).color(color);

    std::promise<void> result;
    auto f = result.get_future();

    const auto handle = [&] (const macs::error_code& ec, const macs::Label& f) {
        auto p = std::move(result);
        if (ec) {
            mail_errors::setRuntimeError(p, ec);
        } else {
            std::cout << "New name is " << f.name()
                      << " color is " << f.color()
                      << " with revision " << f.revision() << std::endl;
            p.set_value();
        }
    };

    try {
        service->labels().updateLabel(factory.product(), handle);
        f.get();
    } catch (const std::exception& e) {
        std::cerr << e.what() << std::endl;
    }

    return 0;
}
