#include <future>

#include "service/get_macs_service.h"
#include "service/options.h"

#include <macs/folder.h>
#include <macs/folder_factory.h>
#include <macs_pg/mailish/folder_info_factory.h>

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, fid, path, parent, name;
    uint64_t uidvalidity;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), ExternalPath(path),
                                          FolderName(name), Fid(fid),
                                          ParentFid(parent).def(macs::Folder::noParent),
                                          UidValidity(uidvalidity));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    std::cout << "# Update mailish folder with path=\"" << path << "\"";

    if (!parent.empty()) {
        std::cout << " in folder with fid=" << parent;
    }

    try {
        macs::MailishFolderInfoFactory infoFactory;
        infoFactory
                .externalPath(path)
                .uidValidity(uidvalidity);

        macs::FolderFactory folderFactory;
        folderFactory
            .fid(fid)
            .name(name)
            .parentId(parent);

        service->mailish().updateFolder(folderFactory.product(), infoFactory.release());
    } catch (const std::exception& e) {
        std::cerr << e.what() << std::endl;
    }

    return 0;
}
