#include <future>

#include <service/get_macs_service.h>
#include <service/options.h>
#include <handlers_helper.h>
#include "envelope_status.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    const std::string descr = "the statuses to set (required).\n"
                              "Available options are: " + getPossibleStatuses();
    std::string uid, dsn, mid, status;
    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Mid(mid),
                                          String(status, "status", descr));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    std::cout << "Update status to " << status << " for mid=" << mid
              << " for uid=" << uid << std::endl;

    auto service = getMacsService(uid, dsn);
    try {
        hooks::Promise result;
        auto f = result.get_future();
        service->envelopes().updateStatus(std::list<std::string>{mid}, getStatus( status ),
                hooks::OnUpdate(result));
        f.get();
    } catch ( const std::exception & e ) {
        std::cerr << e.what() << std::endl;
        return -1;
    }

    return 0;
}
