#include <iostream>

#include "service/params.h"
#include "service/options.h"
#include "service/get_macs_service.h"
#include "subscription_io.h"

using namespace macs::pg::utils;


int main(int argc, char **argv) {
    std::string dsn;
    std::string uid;
    std::int64_t subscriptionId;
    std::string subscriptionActionStr;

    const auto err = parse(argc, argv).as(Dsn(dsn), Uid(uid),
                                          SubscriptionId(subscriptionId),
                                          SubscriptionAction(subscriptionActionStr));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getShard("42", dsn);
    macs::error_code ec;

    if (subscriptionActionStr.empty()) {
        std::cout << "# MarkFailed" << std::endl;
        OnSubscription handler;
        auto data = service->subscriptions().markFailed(uid, subscriptionId, "", macs::io::use_sync[ec]);
        handler(ec, data);
    } else {
        std::cout << "# TransitState" <<  subscriptionActionStr << std::endl;
        auto subscriptionAction = macs::pg::SubscriptionAction::fromString(subscriptionActionStr);
        OnSubscription handler;
        auto data = service->subscriptions().transitState(uid, subscriptionId, subscriptionAction, macs::io::use_sync[ec]);
        handler(ec, data);
    }

    return 0;
}