LIBRARY()

OWNER(
    g:mail
)

CFLAGS(
    -DBOOST_HANA_CONFIG_ENABLE_STRING_UDL
    -Wno-gnu-string-literal-operator-template
)

PEERDIR(
    mail/macs
    mail/pgg
)

ADDINCL(
    GLOBAL mail/macs_pg/include
)

FILES(
    etc/query.conf
)

SRCS(
    src/changelog/change.cc
    src/changelog/pgg_repository.cc
    src/logging.cc
    src/envelope/recipient.cc
    src/envelope/pgg_repository.cc
    src/thread/threads_chooser.cc
    src/thread/pgg_repository.cc
    src/subscribed_folders/subscribed_folder.cc
    src/subscribed_folders/pgg_repository.cc
    src/macs_pg.cc
    src/database/database_info.cc
    src/integration/common_configure.cc
    src/service/factory.cc
    src/subscription/subscription.cc
    src/subscription/unsubscribe_task.cc
    src/subscription/pgg_repository.cc
    src/folder/folders_converter.cc
    src/folder/modify_master.cc
    src/folder/clear_cascade_transaction.cc
    src/folder/create_folder_by_path.cc
    src/folder/pgg_repository.cc
    src/shared_folders/pgg_repository.cc
    src/label/pgg_repository.cc
    src/imap/pgg_repository.cc
    src/mailish/folder.cc
    src/mailish/auth_data.cc
    src/mailish/account.cc
    src/mailish/message.cc
    src/mailish/move_coords.cc
    src/mailish/folder_info.cc
    src/mailish/pgg_repository.cc
    src/tab/converter.cc
    src/tab/pgg_repository.cc
    src/collectors/collector.cc
    src/collectors/pgg_repository.cc
    src/settings/transform.cc
    src/settings/repository.cc
    src/user/repository.cc
    src/backup/repository.cc
    src/sticker/repository.cc
)

END()

RECURSE(
    tests
    utils/collectors_create_collector
    utils/collectors_delete_collector
    utils/collectors_get_next_envelope_chunk
    utils/collectors_get_shard_collectors
    utils/collectors_get_shard_users
    utils/collectors_get_shard_users_changes
    utils/collectors_reset_collector
    utils/collectors_reset_token
    utils/collectors_update_collector
    utils/collectors_update_last_mid
    utils/collectors_update_skipped_mids
    utils/collectors_update_state
    utils/mailish_delete_folder_entries
)
