#include <mail/mail_errors/error_result/error_result.h>
#include <yamail/data/serialization/json_writer.h>


namespace mail_errors {

std::string makeErrorResult(const error_code& ec) {
    return makeErrorResult(ErrorResult(ec));
}

std::string makeErrorResult(const ErrorResult& er) {
    return yamail::data::serialization::toJson(er).str();
}

}

BOOST_FUSION_ADAPT_STRUCT(mail_errors::ErrorResult,
    category,
    message,
    reason
)
