#pragma once

#include <mail_errors/error_code.h>

namespace mail_errors {

struct ErrorResult {
    ErrorResult(const error_code& ec)
        : category(ec.category().name())
        , message(ec.category().message(ec.value()))
        , reason(ec.what())
    { }

    ErrorResult(std::string category,
                std::string message,
                std::string reason)
        : category(std::move(category))
        , message(std::move(message))
        , reason(std::move(reason))
    { }

    std::string category;
    std::string message;
    std::string reason;
};

std::string makeErrorResult(const error_code& ec);
std::string makeErrorResult(const ErrorResult& er);

}
