#ifndef INCLUDE_MAIL_ERRORS_SET_EXCEPTION_H_
#define INCLUDE_MAIL_ERRORS_SET_EXCEPTION_H_

#include <stdexcept>
#include <mail_errors/error_code.h>

namespace mail_errors {

template <typename Exception, typename Promise>
inline void setException(Promise & p, Exception && e) {
    p.set_exception(std::make_exception_ptr(std::forward<Exception>(e)));
}

template <typename Promise>
inline void setSystemError(Promise & p, const std::string& name, error_code e) {
    setException(p, system_error(e, "in " + name + ": "));
}

template <typename Promise>
inline void setRuntimeError(Promise & p, const std::string & msg) {
    setException(p, std::runtime_error(msg));
}

template <typename Promise, typename Error>
inline void setRuntimeError(Promise & p, const Error & e) {
    setRuntimeError(p, std::string(e.category().name()) + ": " + e.message());
}

} // namespace mail_errors

#endif // INCLUDE_MAIL_ERRORS_SET_EXCEPTION_H_
