#include <mail/mail_errors/unexpected/unexpected.h>


namespace mail_errors {

std::string UnexpectedCategory::message(int v) const {
    switch(UnexpectedError(v)) {
        case UnexpectedError::exception:
            return "unexpected exception";
        case UnexpectedError::condition:
            return "unexpected condition";
    }
    return "unknown enum code";
}

const UnexpectedCategory& getUnexpectedCategory() {
    static UnexpectedCategory instance;
    return instance;
}

error_code::base_type make_error_code(UnexpectedError e) {
    return error_code::base_type(static_cast<int>(e), getUnexpectedCategory());
}

error_code make_error(UnexpectedError e, std::string what) {
    return error_code(e, std::move(what));
}

}
