#pragma once

#include <mail_errors/error_code.h>


namespace mail_errors {

constexpr int ENUM_ERROR_STARTING_VALUE = 1;

enum class UnexpectedError {
    exception = ENUM_ERROR_STARTING_VALUE,
    condition,
};


struct UnexpectedCategory: public error_code::error_category {
    const char* name() const noexcept override {
        return "unexpected";
    }

    std::string message(int v) const override;
};

const UnexpectedCategory& getUnexpectedCategory();

error_code::base_type make_error_code(UnexpectedError e);
error_code make_error(UnexpectedError e, std::string what={});

}

namespace boost::system {

template <>
struct is_error_code_enum<mail_errors::UnexpectedError> : std::true_type { };

}
