#pragma once

#include <mail_getter/MessageAccess.h>

namespace mail_getter {

using MessageAccessByHid = std::unordered_map<Hid, MessageAccessPtr>;

class MessageAccessWithWindat: public MessageAccess {
public:
    MessageAccessWithWindat(MessageAccessPtr mainMessageAccess, MessageAccessByHid windatMessageAccesses)
            : mainMessageAccess(std::move(mainMessageAccess)),
              windatMessageAccesses(std::move(windatMessageAccesses)) {
    }

    MessageAccessWithWindat(MessageAccessWithWindat&&) = default;

    MetaPart getHeaderStruct(const std::string &hid) override {
        return messageAccess(hid)->getHeaderStruct(hid);
    }

    MetaLevel getBodyStruct(const std::string &hid) override {
        return messageAccess(hid)->getBodyStruct(hid);
    }

    std::string getHeader(const std::string &hid) override {
        return messageAccess(hid)->getHeader(hid);
    }

    std::string getBody(const std::string &hid) override {
        return messageAccess(hid)->getBody(hid);
    }

    std::string getWhole() override {
        return messageAccess()->getWhole();
    }

    const std::string& getStId() const override {
        return messageAccess()->getStId();
    }

    MetaAttributes getMessageHeaderParsed(const std::string &hid) override {
        return messageAccess(hid)->getMessageHeaderParsed(hid);
    }

private:
    MessageAccessPtr mainMessageAccess;
    std::unordered_map<std::string, MessageAccessPtr> windatMessageAccesses;

    const MessageAccessPtr& messageAccess(const std::string &hid) const {
        auto it = windatMessageAccesses.find(hid);
        if (it != windatMessageAccesses.end()) {
            if (!it->second) {
                throw std::invalid_argument(std::string(__PRETTY_FUNCTION__) + ": need windatMessageAccess");
            }
            return it->second;
        }
        return messageAccess();
    }

    const MessageAccessPtr& messageAccess() const {
        if (!mainMessageAccess) {
            throw std::invalid_argument(std::string(__PRETTY_FUNCTION__) + ": need mainMessageAccess");
        }
        return mainMessageAccess;
    }
};

}
