#ifndef MESSAGESTORAGE_H
#define MESSAGESTORAGE_H

#include <mail_getter/MessageAccessDefinitions.h>
#include <mail_getter/optional_yield_context.h>
#include <boost/optional.hpp>

namespace mail_getter {

using OptString = boost::optional<std::string>;
using OptMetaAttributes = boost::optional<MetaAttributes>;
using OptMetaPart = boost::optional<MetaPart>;

class MessageStorage {
public:
    virtual ~MessageStorage() {};
    virtual OptMetaPart getHeaderStruct(const std::string &hid, OptYieldContext yc = boost::none) = 0;
    virtual MetaLevel getBodyStruct(const std::string &hid, OptYieldContext yc = boost::none) = 0;
    virtual OptString getHeader(const std::string &hid, OptYieldContext yc = boost::none) = 0;
    virtual OptString getBody(const std::string &hid, OptYieldContext yc = boost::none) = 0;
    virtual std::string getWhole(OptYieldContext yc = boost::none) = 0;
    virtual MetaParts getMetaParts(OptYieldContext yc = boost::none) = 0;
};

} // namespace mail_getter

using MessageStoragePtr = std::unique_ptr<mail_getter::MessageStorage>;

#endif
