#ifndef MESSAGESTORAGEBLOB_H
#define MESSAGESTORAGEBLOB_H

#include <mail_getter/MessageAccessDefinitions.h>
#include <internal/MessageStorage.h>

#include <mail_getter/attachment_storage.h>

namespace mail_getter {

class MessageStorageBlob : public MessageStorage {
public:
    MessageStorageBlob(const std::string& stid, storage::ServicePtr storageService);
    ~MessageStorageBlob() {};
    OptMetaPart getHeaderStruct(const std::string& hid, OptYieldContext yc) override;
    MetaLevel getBodyStruct(const std::string& hid, OptYieldContext yc) override;
    OptString getHeader(const std::string& hid, OptYieldContext yc) override;
    OptString getBody(const std::string& hid, OptYieldContext yc) override;
    std::string getWhole(OptYieldContext yc) override;
    MetaParts getMetaParts(OptYieldContext yc) override;
private:
    void loadAttachments(OptYieldContext yc);
    const AbstractAttachment& getCached() const;

    bool cached_;
    AttachmentStoragePtr attStorage_;
    AttachmentStorage::VectorOfAttachments cachedAttachments_;
    std::string st_id_;
};

} // namespace mail_getter

#endif
