#pragma once

#include <internal/storage/service.h>
#include <internal/MessageStorage.h>
#include <mail_getter/logging.h>
#include <internal/MetaParser.h>
#include <internal/inline_messages.h>

namespace mail_getter {

struct MessageStorageRangeError : std::runtime_error {
    using std::runtime_error::runtime_error;
};

class MessageStorageRange : public MessageStorage {
    using OptMetaLevel = boost::optional<MetaLevel>;
public:
    MessageStorageRange(const Stid& stid, storage::ServicePtr storageService,
            logging::LogPtr logger, MetaParts metaParts, const Recognizer::Wrapper& recognizer);

    OptMetaPart getHeaderStruct(const Hid& hid, OptYieldContext yc = boost::none) override;
    MetaLevel getBodyStruct(const Hid& hid, OptYieldContext yc = boost::none) override;
    OptString getHeader(const Hid& hid, OptYieldContext yc = boost::none) override;
    OptString getBody(const Hid& hid, OptYieldContext yc = boost::none) override;
    std::string getWhole(OptYieldContext yc = boost::none) override;
    MetaParts getMetaParts(OptYieldContext yc = boost::none) override;

private:
    std::string getByRange(const Range& range, OptYieldContext yc);

    OptString getMessageHeader(OptYieldContext yc);
    OptString getPartHeader(const MetaPart& mp, OptYieldContext yc);

    MessageStorage *findInlineMessage(const Hid& hid, OptYieldContext yc);
    OptMetaPart getHeaderStructInlineMessage(const Hid& hid, OptYieldContext yc);
    OptMetaLevel getBodyStructInlineMessage(const Hid& hid, OptYieldContext yc);
    OptString getHeaderInlineMessage(const Hid& hid, OptYieldContext yc);
    OptString getBodyInlineMessage(const Hid& hid, OptYieldContext yc);
    OptString getInlineMessage(const Hid& hid, OptYieldContext yc);

    void log(const logging::Message &msg) {
        if (logger_) {
            logger_->notice("MessageStorageRange", msg);
        }
    }
    const std::string& getRawData(OptYieldContext yc);
private:
    Stid stid_;
    storage::ServicePtr storageService_;
    logging::LogPtr logger_;
    MetaParts metaParts_;
    InlineMessages inlineMessages_;

    OptString rawData_;
    OptString messageHeader_;
    const Recognizer::Wrapper* recognizer;
};

} // namespace mail_getter
