#ifndef MESSAGESTORAGESTRING_H
#define MESSAGESTORAGESTRING_H

#include <memory>
#include <mail_getter/MessageAccessDefinitions.h>
#include <internal/MessageStorage.h>

#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wsign-conversion"
#endif
#include <mimeparser/part.h>
#ifdef __clang__
#pragma clang diagnostic pop
#endif

#include <internal/MetaParser.h>

namespace mail_getter {

class MessageStorageString : public MessageStorage {
public:
    MessageStorageString(std::string _content, const std::string &_prefix);
    ~MessageStorageString();

    OptMetaPart getHeaderStruct(const std::string &hid, OptYieldContext yc) override;
    MetaLevel getBodyStruct(const std::string &hid, OptYieldContext yc) override;
    OptString getHeader(const std::string &hid, OptYieldContext yc) override;
    OptString getBody(const std::string &hid, OptYieldContext yc) override;
    std::string getWhole(OptYieldContext yc) override;
    MetaParts getMetaParts(OptYieldContext yc) override;

private:
    void parse();
    void splitToParts(const mulca_mime::part &p, const std::string &id);

private:
    struct Offset {
        std::size_t begin = 0;
        std::size_t length = 0;
        Offset(std::size_t begin, std::size_t length) : begin(begin), length(length) {}
    };

    std::string content;
    MetaParts meta;
    std::map<std::string, Offset> headersOffsets;
    std::string prefix;
    static const int inlineLevel;
    bool parsed;
};

} // namespace mail_getter

#endif
