#pragma once

#include <libxml/tree.h>
#include <butil/Expat.h>
#include <mail_getter/MessageAccessDefinitions.h>
#include <mail_getter/recognizerWrapper.h>

#define METAPARSER_OK 0
#define METAPARSER_CANTRECODE (-2)
#define METAPARSER_UNKNOWN (-3)
#define METAPARSER_XMLERROR (-10)
#define METAPARSER_INVALIDPARAM (-11)

class MetaParser : private Expat {
    public:
        MetaParser(const Recognizer::Wrapper& recognizer);
        void parserReset();
        /**
         * process parser source string and returns result in *mparts
         * we wait source in cp1251 and returns content of *mparts in utf-8
         * returns: 0 - ok, !=0 - error
         */
        int process(const std::string &source, MetaParts *mparts);
        std::string parserError();

    private:
        static void start(void *me, const char *el, const char **attrs);

    private:
        MetaParts *parts;
        void (*start_handler)(void*, const char*, const char**);
        int rc;
        const Recognizer::Wrapper* recognizer;
};

inline std::string removeCRLF(std::string str) {
    auto it = std::remove_if(str.begin(), str.end(), [](char c) {
        return c == '\r' || c == '\n';
    });
    str.erase(it, str.end());
    return str;
}
